//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace HTMLViewer
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class HTMLForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label webAddressLabel;
		private System.Windows.Forms.Button htmlSource;
		private System.Windows.Forms.TextBox sourceTextBox;
		private System.Windows.Forms.Button closeButton;
		private string strSource = null;
		private HTMLPageGet page;
		// Identyfikatory schematu
		private const string HTTP = "http://";
		private const string quoteAddress = "http://moneycentral.msn.com/scripts/webquote.dll?iPage=lqd&Symbol=";
		private System.Windows.Forms.TextBox url;
		private System.Windows.Forms.TextBox stockSymbol;
		private System.Windows.Forms.Label stockSymbolLabel;
		private System.Windows.Forms.Label daysHighLabel;
		private System.Windows.Forms.TextBox daysHigh;
		private System.Windows.Forms.Label daysLowLabel;
		private System.Windows.Forms.TextBox daysLow;
		private System.Windows.Forms.Label lastLabel;
		private System.Windows.Forms.TextBox last;
		private System.Windows.Forms.Label volumeLabel;
		private System.Windows.Forms.TextBox volume;
		private System.Windows.Forms.Button quoteButton;
		private System.Windows.Forms.TextBox percentChange;
		private System.Windows.Forms.Label percentChangeLabel;
		private System.Windows.Forms.Label changeLabel;
		private System.Windows.Forms.TextBox change;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public HTMLForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
			this.Height = 100;
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.url = new System.Windows.Forms.TextBox();
			this.closeButton = new System.Windows.Forms.Button();
			this.stockSymbolLabel = new System.Windows.Forms.Label();
			this.sourceTextBox = new System.Windows.Forms.TextBox();
			this.htmlSource = new System.Windows.Forms.Button();
			this.stockSymbol = new System.Windows.Forms.TextBox();
			this.webAddressLabel = new System.Windows.Forms.Label();
			this.daysHighLabel = new System.Windows.Forms.Label();
			this.daysHigh = new System.Windows.Forms.TextBox();
			this.daysLowLabel = new System.Windows.Forms.Label();
			this.daysLow = new System.Windows.Forms.TextBox();
			this.lastLabel = new System.Windows.Forms.Label();
			this.last = new System.Windows.Forms.TextBox();
			this.percentChangeLabel = new System.Windows.Forms.Label();
			this.percentChange = new System.Windows.Forms.TextBox();
			this.volumeLabel = new System.Windows.Forms.Label();
			this.volume = new System.Windows.Forms.TextBox();
			this.quoteButton = new System.Windows.Forms.Button();
			this.changeLabel = new System.Windows.Forms.Label();
			this.change = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// url
			// 
			this.url.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.url.Location = new System.Drawing.Point(112, 16);
			this.url.Name = "url";
			this.url.ReadOnly = true;
			this.url.Size = new System.Drawing.Size(384, 22);
			this.url.TabIndex = 1;
			this.url.Text = quoteAddress;
			this.url.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.OnKeyPress);
			// 
			// closeButton
			// 
			this.closeButton.BackColor = System.Drawing.Color.Lavender;
			this.closeButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.closeButton.Location = new System.Drawing.Point(600, 16);
			this.closeButton.Name = "closeButton";
			this.closeButton.TabIndex = 4;
			this.closeButton.Text = "Zamknij";
			this.closeButton.Click += new System.EventHandler(this.OnClose);
			// 
			// stockSymbolLabel
			// 
			this.stockSymbolLabel.BackColor = System.Drawing.Color.Lavender;
			this.stockSymbolLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.stockSymbolLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.stockSymbolLabel.Location = new System.Drawing.Point(16, 48);
			this.stockSymbolLabel.Name = "stockSymbolLabel";
			this.stockSymbolLabel.Size = new System.Drawing.Size(88, 20);
			this.stockSymbolLabel.TabIndex = 0;
			this.stockSymbolLabel.Text = "Symbol akcji";
			// 
			// sourceTextBox
			// 
			this.sourceTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.sourceTextBox.Location = new System.Drawing.Point(16, 80);
			this.sourceTextBox.Multiline = true;
			this.sourceTextBox.Name = "sourceTextBox";
			this.sourceTextBox.ReadOnly = true;
			this.sourceTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.sourceTextBox.Size = new System.Drawing.Size(664, 464);
			this.sourceTextBox.TabIndex = 3;
			this.sourceTextBox.Text = "";
			this.sourceTextBox.Visible = false;
			// 
			// htmlSource
			// 
			this.htmlSource.BackColor = System.Drawing.Color.Lavender;
			this.htmlSource.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.htmlSource.Location = new System.Drawing.Point(512, 16);
			this.htmlSource.Name = "htmlSource";
			this.htmlSource.TabIndex = 2;
			this.htmlSource.Text = "rdo";
			this.htmlSource.Click += new System.EventHandler(this.OnGetSource);
			// 
			// stockSymbol
			// 
			this.stockSymbol.Location = new System.Drawing.Point(112, 48);
			this.stockSymbol.Name = "stockSymbol";
			this.stockSymbol.TabIndex = 5;
			this.stockSymbol.Text = "AVID";
			// 
			// webAddressLabel
			// 
			this.webAddressLabel.BackColor = System.Drawing.Color.Lavender;
			this.webAddressLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.webAddressLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.webAddressLabel.Location = new System.Drawing.Point(16, 16);
			this.webAddressLabel.Name = "webAddressLabel";
			this.webAddressLabel.Size = new System.Drawing.Size(88, 20);
			this.webAddressLabel.TabIndex = 0;
			this.webAddressLabel.Text = "Adres internetowy";
			// 
			// daysHighLabel
			// 
			this.daysHighLabel.BackColor = System.Drawing.Color.Lavender;
			this.daysHighLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.daysHighLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.daysHighLabel.Location = new System.Drawing.Point(24, 184);
			this.daysHighLabel.Name = "daysHighLabel";
			this.daysHighLabel.Size = new System.Drawing.Size(88, 20);
			this.daysHighLabel.TabIndex = 0;
			this.daysHighLabel.Text = "Najw. kurs dnia";
			// 
			// daysHigh
			// 
			this.daysHigh.Location = new System.Drawing.Point(120, 184);
			this.daysHigh.Name = "daysHigh";
			this.daysHigh.ReadOnly = true;
			this.daysHigh.TabIndex = 5;
			this.daysHigh.Text = "";
			// 
			// daysLowLabel
			// 
			this.daysLowLabel.BackColor = System.Drawing.Color.Lavender;
			this.daysLowLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.daysLowLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.daysLowLabel.Location = new System.Drawing.Point(24, 160);
			this.daysLowLabel.Name = "daysLowLabel";
			this.daysLowLabel.Size = new System.Drawing.Size(88, 20);
			this.daysLowLabel.TabIndex = 0;
			this.daysLowLabel.Text = "Najn. kurs dnia";
			// 
			// daysLow
			// 
			this.daysLow.Location = new System.Drawing.Point(120, 160);
			this.daysLow.Name = "daysLow";
			this.daysLow.ReadOnly = true;
			this.daysLow.TabIndex = 5;
			this.daysLow.Text = "";
			// 
			// lastLabel
			// 
			this.lastLabel.BackColor = System.Drawing.Color.Lavender;
			this.lastLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.lastLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lastLabel.Location = new System.Drawing.Point(24, 88);
			this.lastLabel.Name = "lastLabel";
			this.lastLabel.Size = new System.Drawing.Size(88, 20);
			this.lastLabel.TabIndex = 0;
			this.lastLabel.Text = "Ostatni";
			// 
			// last
			// 
			this.last.Location = new System.Drawing.Point(120, 88);
			this.last.Name = "last";
			this.last.ReadOnly = true;
			this.last.TabIndex = 5;
			this.last.Text = "";
			// 
			// percentChangeLabel
			// 
			this.percentChangeLabel.BackColor = System.Drawing.Color.Lavender;
			this.percentChangeLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.percentChangeLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.percentChangeLabel.Location = new System.Drawing.Point(24, 136);
			this.percentChangeLabel.Name = "percentChangeLabel";
			this.percentChangeLabel.Size = new System.Drawing.Size(88, 20);
			this.percentChangeLabel.TabIndex = 0;
			this.percentChangeLabel.Text = "Zmiana %";
			// 
			// percentChange
			// 
			this.percentChange.Location = new System.Drawing.Point(120, 136);
			this.percentChange.Name = "percentChange";
			this.percentChange.ReadOnly = true;
			this.percentChange.TabIndex = 5;
			this.percentChange.Text = "";
			// 
			// volumeLabel
			// 
			this.volumeLabel.BackColor = System.Drawing.Color.Lavender;
			this.volumeLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.volumeLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.volumeLabel.Location = new System.Drawing.Point(24, 208);
			this.volumeLabel.Name = "volumeLabel";
			this.volumeLabel.Size = new System.Drawing.Size(88, 20);
			this.volumeLabel.TabIndex = 0;
			this.volumeLabel.Text = "Obrt";
			// 
			// volume
			// 
			this.volume.Location = new System.Drawing.Point(120, 208);
			this.volume.Name = "volume";
			this.volume.ReadOnly = true;
			this.volume.TabIndex = 5;
			this.volume.Text = "";
			// 
			// quoteButton
			// 
			this.quoteButton.BackColor = System.Drawing.Color.Lavender;
			this.quoteButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.quoteButton.Location = new System.Drawing.Point(512, 48);
			this.quoteButton.Name = "quoteButton";
			this.quoteButton.TabIndex = 2;
			this.quoteButton.Text = "Kurs";
			this.quoteButton.Click += new System.EventHandler(this.OnQuote);
			// 
			// changeLabel
			// 
			this.changeLabel.BackColor = System.Drawing.Color.Lavender;
			this.changeLabel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.changeLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.changeLabel.Location = new System.Drawing.Point(24, 112);
			this.changeLabel.Name = "changeLabel";
			this.changeLabel.Size = new System.Drawing.Size(88, 20);
			this.changeLabel.TabIndex = 0;
			this.changeLabel.Text = "Zmiana";
			// 
			// change
			// 
			this.change.Location = new System.Drawing.Point(120, 112);
			this.change.Name = "change";
			this.change.ReadOnly = true;
			this.change.TabIndex = 5;
			this.change.Text = "";
			// 
			// HTMLForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.Blue;
			this.ClientSize = new System.Drawing.Size(696, 565);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.change,
																		  this.changeLabel,
																		  this.quoteButton,
																		  this.volume,
																		  this.volumeLabel,
																		  this.percentChange,
																		  this.percentChangeLabel,
																		  this.last,
																		  this.lastLabel,
																		  this.daysLow,
																		  this.daysLowLabel,
																		  this.daysHigh,
																		  this.daysHighLabel,
																		  this.stockSymbolLabel,
																		  this.stockSymbol,
																		  this.closeButton,
																		  this.sourceTextBox,
																		  this.htmlSource,
																		  this.url,
																		  this.webAddressLabel});
			this.Name = "HTMLForm";
			this.Text = "Przegldarka HTML";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new HTMLForm());
		}

		private void GetPageSource()
		{
			string strAddress = url.Text.Trim();
			strAddress = strAddress.ToLower();
			if (!strAddress.StartsWith(HTTP))
			{
				MessageBox.Show("Wybrano niewaciwy protok.", "Bdny identyfikator schematu", MessageBoxButtons.OK, MessageBoxIcon.Information);
				url.Text = HTTP;
			}
			else
			{
				// Utworzenie obiektu GetWebPageSource
				// "http://moneycentral.msn.com/scripts/webquote.dll?iPage=lqd&Symbol=";
				 page = new HTMLPageGet(strAddress + stockSymbol.Text, stockSymbol.Text);
			}		
		}

		private void showSource()
		{
			daysHighLabel.Visible = false;
			daysHigh.Visible = false;
			daysLowLabel.Visible = false;
			daysLow.Visible = false;
			lastLabel.Visible = false;
			last.Visible = false;
			percentChangeLabel.Visible = false;
			percentChange.Visible = false;
			changeLabel.Visible = false;
			change.Visible = false;
			volumeLabel.Visible = false;
			volume.Visible = false;
			sourceTextBox.Text = strSource;

			HTMLForm.ActiveForm.Height = 608;

			sourceTextBox.Visible = true;
		}

		private void showQuote()
		{
			sourceTextBox.Visible = false;
			Quote q = page.Quote;

			daysHigh.Text = q.High;
			daysLow.Text = q.Low;
			last.Text = q.Last;
			percentChange.Text = q.PercentChange;
			volume.Text = q.Volume;
			change.Text = q.Change;

			HTMLForm.ActiveForm.Height = 296;

			daysHighLabel.Visible = true;
			daysHigh.Visible = true;
			daysLowLabel.Visible = true;
			daysLow.Visible = true;
			lastLabel.Visible = true;
			last.Visible = true;
			percentChangeLabel.Visible = true;
			percentChange.Visible = true;
			changeLabel.Visible = true;
			change.Visible = true;
			volumeLabel.Visible = true;
			volume.Visible = true;
		}

		private void OnClose(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void OnKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			char chr = e.KeyChar;
			// 13 = Enter
			if (chr == 13)
			{
				GetPageSource();
				strSource = page.Source;
				showSource();
			}

		}

		private void OnGetSource(object sender, System.EventArgs e)
		{
			GetPageSource();
			strSource = page.Source;
			showSource();
		}

		private void OnQuote(object sender, System.EventArgs e)
		{
			GetPageSource();
			showQuote();
		}
	}
}
